"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Portal = void 0;
var _interop_require_default = require("@swc/helpers/lib/_interop_require_default.js").default;
var _react = _interop_require_default(require("react"));
var _reactDom = require("react-dom");
const Portal = ({ children , type  })=>{
    let portalNode = _react.default.useRef(null);
    let [, forceUpdate] = _react.default.useState();
    _react.default.useEffect(()=>{
        portalNode.current = document.createElement(type);
        document.body.appendChild(portalNode.current);
        forceUpdate({});
        return ()=>{
            if (portalNode.current) {
                document.body.removeChild(portalNode.current);
            }
        };
    }, [
        type
    ]);
    return portalNode.current ? /*#__PURE__*/ (0, _reactDom).createPortal(children, portalNode.current) : null;
};
exports.Portal = Portal;

if ((typeof exports.default === 'function' || (typeof exports.default === 'object' && exports.default !== null)) && typeof exports.default.__esModule === 'undefined') {
  Object.defineProperty(exports.default, '__esModule', { value: true });
  Object.assign(exports.default, exports);
  module.exports = exports.default;
}

//# sourceMappingURL=index.js.map