import React from 'react';
import type { FlightRouterState, FlightData } from '../../server/app-render';
/**
 * Fetch the flight data for the provided url. Takes in the current router state to decide what to render server-side.
 */
export declare function fetchServerResponse(url: URL, flightRouterState: FlightRouterState): {
    readRoot: () => FlightData;
};
/**
 * The global router that wraps the application components.
 */
export default function AppRouter({ initialTree, initialCanonicalUrl, initialStylesheets, children, hotReloader, }: {
    initialTree: FlightRouterState;
    initialCanonicalUrl: string;
    initialStylesheets: string[];
    children: React.ReactNode;
    hotReloader?: React.ReactNode;
}): JSX.Element;
