/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import type { webpack5 } from 'next/dist/compiled/webpack/webpack';
interface Options {
    dev: boolean;
    appDir: boolean;
    pageExtensions: string[];
}
export declare class FlightManifestPlugin {
    dev: Options['dev'];
    pageExtensions: Options['pageExtensions'];
    appDir: Options['appDir'];
    constructor(options: Options);
    apply(compiler: webpack5.Compiler): void;
    createAsset(assets: webpack5.Compilation['assets'], compilation: webpack5.Compilation, context: string): void;
}
export {};
