"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = edgeSSRLoader;
var _getModuleBuildInfo = require("../get-module-build-info");
var _stringifyRequest = require("../../stringify-request");
async function edgeSSRLoader() {
    const { dev , page , buildId , absolutePagePath , absoluteAppPath , absoluteDocumentPath , absolute500Path , absoluteErrorPath , isServerComponent , stringifiedConfig ,  } = this.getOptions();
    const buildInfo = (0, _getModuleBuildInfo).getModuleBuildInfo(this._module);
    buildInfo.nextEdgeSSR = {
        isServerComponent: isServerComponent === "true",
        page: page
    };
    buildInfo.route = {
        page,
        absolutePagePath
    };
    const stringifiedPagePath = (0, _stringifyRequest).stringifyRequest(this, absolutePagePath);
    const stringifiedAppPath = (0, _stringifyRequest).stringifyRequest(this, absoluteAppPath);
    const stringifiedErrorPath = (0, _stringifyRequest).stringifyRequest(this, absoluteErrorPath);
    const stringifiedDocumentPath = (0, _stringifyRequest).stringifyRequest(this, absoluteDocumentPath);
    const stringified500Path = absolute500Path ? (0, _stringifyRequest).stringifyRequest(this, absolute500Path) : null;
    const transformed = `
    import { adapter, enhanceGlobals } from 'next/dist/server/web/adapter'
    import { getRender } from 'next/dist/build/webpack/loaders/next-edge-ssr-loader/render'

    import Document from ${stringifiedDocumentPath}

    enhanceGlobals()

    const appMod = require(${stringifiedAppPath})
    const pageMod = require(${stringifiedPagePath})
    const errorMod = require(${stringifiedErrorPath})
    const error500Mod = ${stringified500Path ? `require(${stringified500Path})` : "null"}

    const buildManifest = self.__BUILD_MANIFEST
    const reactLoadableManifest = self.__REACT_LOADABLE_MANIFEST
    const rscManifest = self.__RSC_MANIFEST

    const render = getRender({
      dev: ${dev},
      page: ${JSON.stringify(page)},
      appMod,
      pageMod,
      errorMod,
      error500Mod,
      Document,
      buildManifest,
      reactLoadableManifest,
      serverComponentManifest: ${isServerComponent} ? rscManifest : null,
      config: ${stringifiedConfig},
      buildId: ${JSON.stringify(buildId)},
    })

    export default function(opts) {
      return adapter({
        ...opts,
        handler: render
      })
    }`;
    return transformed;
}

//# sourceMappingURL=index.js.map