var FormspreeReact = (function (exports, React) {
	'use strict';

	function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

	var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

	var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

	function _arrayWithHoles(arr) {
	  if (Array.isArray(arr)) return arr;
	}

	var arrayWithHoles$1 = _arrayWithHoles;

	function _iterableToArrayLimit(arr, i) {
	  if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
	    return;
	  }

	  var _arr = [];
	  var _n = true;
	  var _d = false;
	  var _e = undefined;

	  try {
	    for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
	      _arr.push(_s.value);

	      if (i && _arr.length === i) break;
	    }
	  } catch (err) {
	    _d = true;
	    _e = err;
	  } finally {
	    try {
	      if (!_n && _i["return"] != null) _i["return"]();
	    } finally {
	      if (_d) throw _e;
	    }
	  }

	  return _arr;
	}

	var iterableToArrayLimit$1 = _iterableToArrayLimit;

	function _nonIterableRest() {
	  throw new TypeError("Invalid attempt to destructure non-iterable instance");
	}

	var nonIterableRest$1 = _nonIterableRest;

	var arrayWithHoles = arrayWithHoles$1;

	var iterableToArrayLimit = iterableToArrayLimit$1;

	var nonIterableRest = nonIterableRest$1;

	function _slicedToArray(arr, i) {
	  return arrayWithHoles(arr) || iterableToArrayLimit(arr, i) || nonIterableRest();
	}

	var slicedToArray = _slicedToArray;

	/**
	 * @this {Promise}
	 */
	function finallyConstructor(callback) {
	  var constructor = this.constructor;
	  return this.then(
	    function(value) {
	      // @ts-ignore
	      return constructor.resolve(callback()).then(function() {
	        return value;
	      });
	    },
	    function(reason) {
	      // @ts-ignore
	      return constructor.resolve(callback()).then(function() {
	        // @ts-ignore
	        return constructor.reject(reason);
	      });
	    }
	  );
	}

	function allSettled(arr) {
	  var P = this;
	  return new P(function(resolve, reject) {
	    if (!(arr && typeof arr.length !== 'undefined')) {
	      return reject(
	        new TypeError(
	          typeof arr +
	            ' ' +
	            arr +
	            ' is not iterable(cannot read property Symbol(Symbol.iterator))'
	        )
	      );
	    }
	    var args = Array.prototype.slice.call(arr);
	    if (args.length === 0) return resolve([]);
	    var remaining = args.length;

	    function res(i, val) {
	      if (val && (typeof val === 'object' || typeof val === 'function')) {
	        var then = val.then;
	        if (typeof then === 'function') {
	          then.call(
	            val,
	            function(val) {
	              res(i, val);
	            },
	            function(e) {
	              args[i] = { status: 'rejected', reason: e };
	              if (--remaining === 0) {
	                resolve(args);
	              }
	            }
	          );
	          return;
	        }
	      }
	      args[i] = { status: 'fulfilled', value: val };
	      if (--remaining === 0) {
	        resolve(args);
	      }
	    }

	    for (var i = 0; i < args.length; i++) {
	      res(i, args[i]);
	    }
	  });
	}

	// Store setTimeout reference so promise-polyfill will be unaffected by
	// other code modifying setTimeout (like sinon.useFakeTimers())
	var setTimeoutFunc = setTimeout;

	function isArray(x) {
	  return Boolean(x && typeof x.length !== 'undefined');
	}

	function noop() {}

	// Polyfill for Function.prototype.bind
	function bind(fn, thisArg) {
	  return function() {
	    fn.apply(thisArg, arguments);
	  };
	}

	/**
	 * @constructor
	 * @param {Function} fn
	 */
	function Promise$1(fn) {
	  if (!(this instanceof Promise$1))
	    throw new TypeError('Promises must be constructed via new');
	  if (typeof fn !== 'function') throw new TypeError('not a function');
	  /** @type {!number} */
	  this._state = 0;
	  /** @type {!boolean} */
	  this._handled = false;
	  /** @type {Promise|undefined} */
	  this._value = undefined;
	  /** @type {!Array<!Function>} */
	  this._deferreds = [];

	  doResolve(fn, this);
	}

	function handle(self, deferred) {
	  while (self._state === 3) {
	    self = self._value;
	  }
	  if (self._state === 0) {
	    self._deferreds.push(deferred);
	    return;
	  }
	  self._handled = true;
	  Promise$1._immediateFn(function() {
	    var cb = self._state === 1 ? deferred.onFulfilled : deferred.onRejected;
	    if (cb === null) {
	      (self._state === 1 ? resolve : reject)(deferred.promise, self._value);
	      return;
	    }
	    var ret;
	    try {
	      ret = cb(self._value);
	    } catch (e) {
	      reject(deferred.promise, e);
	      return;
	    }
	    resolve(deferred.promise, ret);
	  });
	}

	function resolve(self, newValue) {
	  try {
	    // Promise Resolution Procedure: https://github.com/promises-aplus/promises-spec#the-promise-resolution-procedure
	    if (newValue === self)
	      throw new TypeError('A promise cannot be resolved with itself.');
	    if (
	      newValue &&
	      (typeof newValue === 'object' || typeof newValue === 'function')
	    ) {
	      var then = newValue.then;
	      if (newValue instanceof Promise$1) {
	        self._state = 3;
	        self._value = newValue;
	        finale(self);
	        return;
	      } else if (typeof then === 'function') {
	        doResolve(bind(then, newValue), self);
	        return;
	      }
	    }
	    self._state = 1;
	    self._value = newValue;
	    finale(self);
	  } catch (e) {
	    reject(self, e);
	  }
	}

	function reject(self, newValue) {
	  self._state = 2;
	  self._value = newValue;
	  finale(self);
	}

	function finale(self) {
	  if (self._state === 2 && self._deferreds.length === 0) {
	    Promise$1._immediateFn(function() {
	      if (!self._handled) {
	        Promise$1._unhandledRejectionFn(self._value);
	      }
	    });
	  }

	  for (var i = 0, len = self._deferreds.length; i < len; i++) {
	    handle(self, self._deferreds[i]);
	  }
	  self._deferreds = null;
	}

	/**
	 * @constructor
	 */
	function Handler(onFulfilled, onRejected, promise) {
	  this.onFulfilled = typeof onFulfilled === 'function' ? onFulfilled : null;
	  this.onRejected = typeof onRejected === 'function' ? onRejected : null;
	  this.promise = promise;
	}

	/**
	 * Take a potentially misbehaving resolver function and make sure
	 * onFulfilled and onRejected are only called once.
	 *
	 * Makes no guarantees about asynchrony.
	 */
	function doResolve(fn, self) {
	  var done = false;
	  try {
	    fn(
	      function(value) {
	        if (done) return;
	        done = true;
	        resolve(self, value);
	      },
	      function(reason) {
	        if (done) return;
	        done = true;
	        reject(self, reason);
	      }
	    );
	  } catch (ex) {
	    if (done) return;
	    done = true;
	    reject(self, ex);
	  }
	}

	Promise$1.prototype['catch'] = function(onRejected) {
	  return this.then(null, onRejected);
	};

	Promise$1.prototype.then = function(onFulfilled, onRejected) {
	  // @ts-ignore
	  var prom = new this.constructor(noop);

	  handle(this, new Handler(onFulfilled, onRejected, prom));
	  return prom;
	};

	Promise$1.prototype['finally'] = finallyConstructor;

	Promise$1.all = function(arr) {
	  return new Promise$1(function(resolve, reject) {
	    if (!isArray(arr)) {
	      return reject(new TypeError('Promise.all accepts an array'));
	    }

	    var args = Array.prototype.slice.call(arr);
	    if (args.length === 0) return resolve([]);
	    var remaining = args.length;

	    function res(i, val) {
	      try {
	        if (val && (typeof val === 'object' || typeof val === 'function')) {
	          var then = val.then;
	          if (typeof then === 'function') {
	            then.call(
	              val,
	              function(val) {
	                res(i, val);
	              },
	              reject
	            );
	            return;
	          }
	        }
	        args[i] = val;
	        if (--remaining === 0) {
	          resolve(args);
	        }
	      } catch (ex) {
	        reject(ex);
	      }
	    }

	    for (var i = 0; i < args.length; i++) {
	      res(i, args[i]);
	    }
	  });
	};

	Promise$1.allSettled = allSettled;

	Promise$1.resolve = function(value) {
	  if (value && typeof value === 'object' && value.constructor === Promise$1) {
	    return value;
	  }

	  return new Promise$1(function(resolve) {
	    resolve(value);
	  });
	};

	Promise$1.reject = function(value) {
	  return new Promise$1(function(resolve, reject) {
	    reject(value);
	  });
	};

	Promise$1.race = function(arr) {
	  return new Promise$1(function(resolve, reject) {
	    if (!isArray(arr)) {
	      return reject(new TypeError('Promise.race accepts an array'));
	    }

	    for (var i = 0, len = arr.length; i < len; i++) {
	      Promise$1.resolve(arr[i]).then(resolve, reject);
	    }
	  });
	};

	// Use polyfill for setImmediate for performance gains
	Promise$1._immediateFn =
	  // @ts-ignore
	  (typeof setImmediate === 'function' &&
	    function(fn) {
	      // @ts-ignore
	      setImmediate(fn);
	    }) ||
	  function(fn) {
	    setTimeoutFunc(fn, 0);
	  };

	Promise$1._unhandledRejectionFn = function _unhandledRejectionFn(err) {
	  if (typeof console !== 'undefined' && console) {
	    console.warn('Possible Unhandled Promise Rejection:', err); // eslint-disable-line no-console
	  }
	};

	var fetchBrowser = {exports: {}};

	(function (module, exports) {
	(function (self) {

	  function fetchPonyfill(options) {
	    var Promise = options && options.Promise || self.Promise;
	    var XMLHttpRequest = options && options.XMLHttpRequest || self.XMLHttpRequest;
	    var global = self;

	    return (function () {
	      var self = Object.create(global, {
	        fetch: {
	          value: undefined,
	          writable: true
	        }
	      });

	      (function(self) {

	        if (self.fetch) {
	          return
	        }

	        var support = {
	          searchParams: 'URLSearchParams' in self,
	          iterable: 'Symbol' in self && 'iterator' in Symbol,
	          blob: 'FileReader' in self && 'Blob' in self && (function() {
	            try {
	              new Blob();
	              return true
	            } catch(e) {
	              return false
	            }
	          })(),
	          formData: 'FormData' in self,
	          arrayBuffer: 'ArrayBuffer' in self
	        };

	        if (support.arrayBuffer) {
	          var viewClasses = [
	            '[object Int8Array]',
	            '[object Uint8Array]',
	            '[object Uint8ClampedArray]',
	            '[object Int16Array]',
	            '[object Uint16Array]',
	            '[object Int32Array]',
	            '[object Uint32Array]',
	            '[object Float32Array]',
	            '[object Float64Array]'
	          ];

	          var isDataView = function(obj) {
	            return obj && DataView.prototype.isPrototypeOf(obj)
	          };

	          var isArrayBufferView = ArrayBuffer.isView || function(obj) {
	            return obj && viewClasses.indexOf(Object.prototype.toString.call(obj)) > -1
	          };
	        }

	        function normalizeName(name) {
	          if (typeof name !== 'string') {
	            name = String(name);
	          }
	          if (/[^a-z0-9\-#$%&'*+.\^_`|~]/i.test(name)) {
	            throw new TypeError('Invalid character in header field name')
	          }
	          return name.toLowerCase()
	        }

	        function normalizeValue(value) {
	          if (typeof value !== 'string') {
	            value = String(value);
	          }
	          return value
	        }

	        // Build a destructive iterator for the value list
	        function iteratorFor(items) {
	          var iterator = {
	            next: function() {
	              var value = items.shift();
	              return {done: value === undefined, value: value}
	            }
	          };

	          if (support.iterable) {
	            iterator[Symbol.iterator] = function() {
	              return iterator
	            };
	          }

	          return iterator
	        }

	        function Headers(headers) {
	          this.map = {};

	          if (headers instanceof Headers) {
	            headers.forEach(function(value, name) {
	              this.append(name, value);
	            }, this);
	          } else if (Array.isArray(headers)) {
	            headers.forEach(function(header) {
	              this.append(header[0], header[1]);
	            }, this);
	          } else if (headers) {
	            Object.getOwnPropertyNames(headers).forEach(function(name) {
	              this.append(name, headers[name]);
	            }, this);
	          }
	        }

	        Headers.prototype.append = function(name, value) {
	          name = normalizeName(name);
	          value = normalizeValue(value);
	          var oldValue = this.map[name];
	          this.map[name] = oldValue ? oldValue+','+value : value;
	        };

	        Headers.prototype['delete'] = function(name) {
	          delete this.map[normalizeName(name)];
	        };

	        Headers.prototype.get = function(name) {
	          name = normalizeName(name);
	          return this.has(name) ? this.map[name] : null
	        };

	        Headers.prototype.has = function(name) {
	          return this.map.hasOwnProperty(normalizeName(name))
	        };

	        Headers.prototype.set = function(name, value) {
	          this.map[normalizeName(name)] = normalizeValue(value);
	        };

	        Headers.prototype.forEach = function(callback, thisArg) {
	          for (var name in this.map) {
	            if (this.map.hasOwnProperty(name)) {
	              callback.call(thisArg, this.map[name], name, this);
	            }
	          }
	        };

	        Headers.prototype.keys = function() {
	          var items = [];
	          this.forEach(function(value, name) { items.push(name); });
	          return iteratorFor(items)
	        };

	        Headers.prototype.values = function() {
	          var items = [];
	          this.forEach(function(value) { items.push(value); });
	          return iteratorFor(items)
	        };

	        Headers.prototype.entries = function() {
	          var items = [];
	          this.forEach(function(value, name) { items.push([name, value]); });
	          return iteratorFor(items)
	        };

	        if (support.iterable) {
	          Headers.prototype[Symbol.iterator] = Headers.prototype.entries;
	        }

	        function consumed(body) {
	          if (body.bodyUsed) {
	            return Promise.reject(new TypeError('Already read'))
	          }
	          body.bodyUsed = true;
	        }

	        function fileReaderReady(reader) {
	          return new Promise(function(resolve, reject) {
	            reader.onload = function() {
	              resolve(reader.result);
	            };
	            reader.onerror = function() {
	              reject(reader.error);
	            };
	          })
	        }

	        function readBlobAsArrayBuffer(blob) {
	          var reader = new FileReader();
	          var promise = fileReaderReady(reader);
	          reader.readAsArrayBuffer(blob);
	          return promise
	        }

	        function readBlobAsText(blob) {
	          var reader = new FileReader();
	          var promise = fileReaderReady(reader);
	          reader.readAsText(blob);
	          return promise
	        }

	        function readArrayBufferAsText(buf) {
	          var view = new Uint8Array(buf);
	          var chars = new Array(view.length);

	          for (var i = 0; i < view.length; i++) {
	            chars[i] = String.fromCharCode(view[i]);
	          }
	          return chars.join('')
	        }

	        function bufferClone(buf) {
	          if (buf.slice) {
	            return buf.slice(0)
	          } else {
	            var view = new Uint8Array(buf.byteLength);
	            view.set(new Uint8Array(buf));
	            return view.buffer
	          }
	        }

	        function Body() {
	          this.bodyUsed = false;

	          this._initBody = function(body) {
	            this._bodyInit = body;
	            if (!body) {
	              this._bodyText = '';
	            } else if (typeof body === 'string') {
	              this._bodyText = body;
	            } else if (support.blob && Blob.prototype.isPrototypeOf(body)) {
	              this._bodyBlob = body;
	            } else if (support.formData && FormData.prototype.isPrototypeOf(body)) {
	              this._bodyFormData = body;
	            } else if (support.searchParams && URLSearchParams.prototype.isPrototypeOf(body)) {
	              this._bodyText = body.toString();
	            } else if (support.arrayBuffer && support.blob && isDataView(body)) {
	              this._bodyArrayBuffer = bufferClone(body.buffer);
	              // IE 10-11 can't handle a DataView body.
	              this._bodyInit = new Blob([this._bodyArrayBuffer]);
	            } else if (support.arrayBuffer && (ArrayBuffer.prototype.isPrototypeOf(body) || isArrayBufferView(body))) {
	              this._bodyArrayBuffer = bufferClone(body);
	            } else {
	              throw new Error('unsupported BodyInit type')
	            }

	            if (!this.headers.get('content-type')) {
	              if (typeof body === 'string') {
	                this.headers.set('content-type', 'text/plain;charset=UTF-8');
	              } else if (this._bodyBlob && this._bodyBlob.type) {
	                this.headers.set('content-type', this._bodyBlob.type);
	              } else if (support.searchParams && URLSearchParams.prototype.isPrototypeOf(body)) {
	                this.headers.set('content-type', 'application/x-www-form-urlencoded;charset=UTF-8');
	              }
	            }
	          };

	          if (support.blob) {
	            this.blob = function() {
	              var rejected = consumed(this);
	              if (rejected) {
	                return rejected
	              }

	              if (this._bodyBlob) {
	                return Promise.resolve(this._bodyBlob)
	              } else if (this._bodyArrayBuffer) {
	                return Promise.resolve(new Blob([this._bodyArrayBuffer]))
	              } else if (this._bodyFormData) {
	                throw new Error('could not read FormData body as blob')
	              } else {
	                return Promise.resolve(new Blob([this._bodyText]))
	              }
	            };

	            this.arrayBuffer = function() {
	              if (this._bodyArrayBuffer) {
	                return consumed(this) || Promise.resolve(this._bodyArrayBuffer)
	              } else {
	                return this.blob().then(readBlobAsArrayBuffer)
	              }
	            };
	          }

	          this.text = function() {
	            var rejected = consumed(this);
	            if (rejected) {
	              return rejected
	            }

	            if (this._bodyBlob) {
	              return readBlobAsText(this._bodyBlob)
	            } else if (this._bodyArrayBuffer) {
	              return Promise.resolve(readArrayBufferAsText(this._bodyArrayBuffer))
	            } else if (this._bodyFormData) {
	              throw new Error('could not read FormData body as text')
	            } else {
	              return Promise.resolve(this._bodyText)
	            }
	          };

	          if (support.formData) {
	            this.formData = function() {
	              return this.text().then(decode)
	            };
	          }

	          this.json = function() {
	            return this.text().then(JSON.parse)
	          };

	          return this
	        }

	        // HTTP methods whose capitalization should be normalized
	        var methods = ['DELETE', 'GET', 'HEAD', 'OPTIONS', 'POST', 'PUT'];

	        function normalizeMethod(method) {
	          var upcased = method.toUpperCase();
	          return (methods.indexOf(upcased) > -1) ? upcased : method
	        }

	        function Request(input, options) {
	          options = options || {};
	          var body = options.body;

	          if (input instanceof Request) {
	            if (input.bodyUsed) {
	              throw new TypeError('Already read')
	            }
	            this.url = input.url;
	            this.credentials = input.credentials;
	            if (!options.headers) {
	              this.headers = new Headers(input.headers);
	            }
	            this.method = input.method;
	            this.mode = input.mode;
	            if (!body && input._bodyInit != null) {
	              body = input._bodyInit;
	              input.bodyUsed = true;
	            }
	          } else {
	            this.url = String(input);
	          }

	          this.credentials = options.credentials || this.credentials || 'omit';
	          if (options.headers || !this.headers) {
	            this.headers = new Headers(options.headers);
	          }
	          this.method = normalizeMethod(options.method || this.method || 'GET');
	          this.mode = options.mode || this.mode || null;
	          this.referrer = null;

	          if ((this.method === 'GET' || this.method === 'HEAD') && body) {
	            throw new TypeError('Body not allowed for GET or HEAD requests')
	          }
	          this._initBody(body);
	        }

	        Request.prototype.clone = function() {
	          return new Request(this, { body: this._bodyInit })
	        };

	        function decode(body) {
	          var form = new FormData();
	          body.trim().split('&').forEach(function(bytes) {
	            if (bytes) {
	              var split = bytes.split('=');
	              var name = split.shift().replace(/\+/g, ' ');
	              var value = split.join('=').replace(/\+/g, ' ');
	              form.append(decodeURIComponent(name), decodeURIComponent(value));
	            }
	          });
	          return form
	        }

	        function parseHeaders(rawHeaders) {
	          var headers = new Headers();
	          // Replace instances of \r\n and \n followed by at least one space or horizontal tab with a space
	          // https://tools.ietf.org/html/rfc7230#section-3.2
	          var preProcessedHeaders = rawHeaders.replace(/\r?\n[\t ]+/g, ' ');
	          preProcessedHeaders.split(/\r?\n/).forEach(function(line) {
	            var parts = line.split(':');
	            var key = parts.shift().trim();
	            if (key) {
	              var value = parts.join(':').trim();
	              headers.append(key, value);
	            }
	          });
	          return headers
	        }

	        Body.call(Request.prototype);

	        function Response(bodyInit, options) {
	          if (!options) {
	            options = {};
	          }

	          this.type = 'default';
	          this.status = options.status === undefined ? 200 : options.status;
	          this.ok = this.status >= 200 && this.status < 300;
	          this.statusText = 'statusText' in options ? options.statusText : 'OK';
	          this.headers = new Headers(options.headers);
	          this.url = options.url || '';
	          this._initBody(bodyInit);
	        }

	        Body.call(Response.prototype);

	        Response.prototype.clone = function() {
	          return new Response(this._bodyInit, {
	            status: this.status,
	            statusText: this.statusText,
	            headers: new Headers(this.headers),
	            url: this.url
	          })
	        };

	        Response.error = function() {
	          var response = new Response(null, {status: 0, statusText: ''});
	          response.type = 'error';
	          return response
	        };

	        var redirectStatuses = [301, 302, 303, 307, 308];

	        Response.redirect = function(url, status) {
	          if (redirectStatuses.indexOf(status) === -1) {
	            throw new RangeError('Invalid status code')
	          }

	          return new Response(null, {status: status, headers: {location: url}})
	        };

	        self.Headers = Headers;
	        self.Request = Request;
	        self.Response = Response;

	        self.fetch = function(input, init) {
	          return new Promise(function(resolve, reject) {
	            var request = new Request(input, init);
	            var xhr = new XMLHttpRequest();

	            xhr.onload = function() {
	              var options = {
	                status: xhr.status,
	                statusText: xhr.statusText,
	                headers: parseHeaders(xhr.getAllResponseHeaders() || '')
	              };
	              options.url = 'responseURL' in xhr ? xhr.responseURL : options.headers.get('X-Request-URL');
	              var body = 'response' in xhr ? xhr.response : xhr.responseText;
	              resolve(new Response(body, options));
	            };

	            xhr.onerror = function() {
	              reject(new TypeError('Network request failed'));
	            };

	            xhr.ontimeout = function() {
	              reject(new TypeError('Network request failed'));
	            };

	            xhr.open(request.method, request.url, true);

	            if (request.credentials === 'include') {
	              xhr.withCredentials = true;
	            } else if (request.credentials === 'omit') {
	              xhr.withCredentials = false;
	            }

	            if ('responseType' in xhr && support.blob) {
	              xhr.responseType = 'blob';
	            }

	            request.headers.forEach(function(value, name) {
	              xhr.setRequestHeader(name, value);
	            });

	            xhr.send(typeof request._bodyInit === 'undefined' ? null : request._bodyInit);
	          })
	        };
	        self.fetch.polyfill = true;
	      })(typeof self !== 'undefined' ? self : this);


	      return {
	        fetch: self.fetch,
	        Headers: self.Headers,
	        Request: self.Request,
	        Response: self.Response
	      };
	    }());
	  }

	  {
	    module.exports = fetchPonyfill;
	  }
	}(typeof self !== 'undefined' ? self : typeof commonjsGlobal !== 'undefined' ? commonjsGlobal : commonjsGlobal));
	}(fetchBrowser));

	var fetchPonyfill = fetchBrowser.exports;

	function _classCallCheck(instance, Constructor) {
	  if (!(instance instanceof Constructor)) {
	    throw new TypeError("Cannot call a class as a function");
	  }
	}

	function _defineProperties(target, props) {
	  for (var i = 0; i < props.length; i++) {
	    var descriptor = props[i];
	    descriptor.enumerable = descriptor.enumerable || false;
	    descriptor.configurable = true;
	    if ("value" in descriptor) descriptor.writable = true;
	    Object.defineProperty(target, descriptor.key, descriptor);
	  }
	}

	function _createClass(Constructor, protoProps, staticProps) {
	  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
	  if (staticProps) _defineProperties(Constructor, staticProps);
	  return Constructor;
	}

	var b64 = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=';
	var b64re = /^(?:[A-Za-z\d+\/]{4})*?(?:[A-Za-z\d+\/]{2}(?:==)?|[A-Za-z\d+\/]{3}=?)?$/;
	function btoa(string) {
	  string = String(string);
	  var bitmap,
	      a,
	      b,
	      c,
	      result = '',
	      i = 0,
	      rest = string.length % 3; // To determine the final padding

	  for (; i < string.length;) {
	    if ((a = string.charCodeAt(i++)) > 255 || (b = string.charCodeAt(i++)) > 255 || (c = string.charCodeAt(i++)) > 255) throw new TypeError("Failed to execute 'btoa' on 'Window': The string to be encoded contains characters outside of the Latin1 range.");
	    bitmap = a << 16 | b << 8 | c;
	    result += b64.charAt(bitmap >> 18 & 63) + b64.charAt(bitmap >> 12 & 63) + b64.charAt(bitmap >> 6 & 63) + b64.charAt(bitmap & 63);
	  } // If there's need of padding, replace the last 'A's with equal signs


	  return rest ? result.slice(0, rest - 3) + '==='.substring(rest) : result;
	}
	function atob(string) {
	  // atob can work with strings with whitespaces, even inside the encoded part,
	  // but only \t, \n, \f, \r and ' ', which can be stripped.
	  string = String(string).replace(/[\t\n\f\r ]+/g, '');
	  if (!b64re.test(string)) throw new TypeError("Failed to execute 'atob' on 'Window': The string to be decoded is not correctly encoded."); // Adding the padding if missing, for semplicity

	  string += '=='.slice(2 - (string.length & 3));
	  var bitmap,
	      result = '',
	      r1,
	      r2,
	      i = 0;

	  for (; i < string.length;) {
	    bitmap = b64.indexOf(string.charAt(i++)) << 18 | b64.indexOf(string.charAt(i++)) << 12 | (r1 = b64.indexOf(string.charAt(i++))) << 6 | (r2 = b64.indexOf(string.charAt(i++)));
	    result += r1 === 64 ? String.fromCharCode(bitmap >> 16 & 255) : r2 === 64 ? String.fromCharCode(bitmap >> 16 & 255, bitmap >> 8 & 255) : String.fromCharCode(bitmap >> 16 & 255, bitmap >> 8 & 255, bitmap & 255);
	  }

	  return result;
	}

	var version$1 = "2.6.3";

	/**
	 * Base-64 encodes a (JSON-castable) object.
	 *
	 * @param obj - The object to encode.
	 */

	var encode64 = function encode64(obj) {
	  return btoa(JSON.stringify(obj));
	};
	/**
	 * Generates a client header.
	 *
	 * @param givenLabel
	 */

	var clientHeader = function clientHeader(givenLabel) {
	  var label = "@formspree/core@".concat(version$1);
	  if (!givenLabel) return label;
	  return "".concat(givenLabel, " ").concat(label);
	};
	/**
	 * The current timestamp.
	 */

	var now = function now() {
	  // @ts-ignore
	  return 1 * new Date();
	};

	var webdriver = function webdriver() {
	  return navigator.webdriver || !!document.documentElement.getAttribute(atob('d2ViZHJpdmVy')) || // @ts-ignore
	  !!window.callPhantom || // @ts-ignore
	  !!window._phantom;
	};

	var Session =
	/*#__PURE__*/
	function () {
	  function Session() {
	    _classCallCheck(this, Session);

	    this.loadedAt = now();
	    this.webdriver = webdriver();
	  }

	  _createClass(Session, [{
	    key: "teardown",
	    value: function teardown() {}
	  }, {
	    key: "data",
	    value: function data() {
	      return {
	        loadedAt: this.loadedAt,
	        webdriver: this.webdriver
	      };
	    }
	  }]);

	  return Session;
	}();

	var Client =
	/*#__PURE__*/
	function () {
	  function Client() {
	    var config = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

	    _classCallCheck(this, Client);

	    this.project = config.project;
	    if (typeof window !== 'undefined') this.startBrowserSession();
	  }
	  /**
	   * Starts a browser session.
	   */


	  _createClass(Client, [{
	    key: "startBrowserSession",
	    value: function startBrowserSession() {
	      if (!this.session) {
	        this.session = new Session();
	      }
	    }
	    /**
	     * Teardown the client session.
	     */

	  }, {
	    key: "teardown",
	    value: function teardown() {
	      if (this.session) this.session.teardown();
	    }
	    /**
	     * Submit a form.
	     *
	     * @param formKey - The form key.
	     * @param data - An object or FormData instance containing submission data.
	     * @param args - An object of form submission data.
	     */

	  }, {
	    key: "submitForm",
	    value: function submitForm(formKey, data) {
	      var opts = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
	      var endpoint = opts.endpoint || 'https://formspree.io';
	      var fetchImpl = opts.fetchImpl || fetchPonyfill({
	        Promise: Promise$1
	      }).fetch;
	      var url = this.project ? "".concat(endpoint, "/p/").concat(this.project, "/f/").concat(formKey) : "".concat(endpoint, "/f/").concat(formKey);

	      var serializeBody = function serializeBody(data) {
	        if (data instanceof FormData) return data;
	        return JSON.stringify(data);
	      };

	      var headers = {
	        Accept: 'application/json',
	        'Formspree-Client': clientHeader(opts.clientName)
	      };

	      if (this.session) {
	        headers['Formspree-Session-Data'] = encode64(this.session.data());
	      }

	      if (!(data instanceof FormData)) {
	        headers['Content-Type'] = 'application/json';
	      }

	      var request = {
	        method: 'POST',
	        mode: 'cors',
	        body: serializeBody(data),
	        headers: headers
	      };
	      return fetchImpl(url, request).then(function (response) {
	        return response.json().then(function (body) {
	          return {
	            body: body,
	            response: response
	          };
	        });
	      });
	    }
	  }]);

	  return Client;
	}();
	/**
	 * Constructs the client object.
	 */

	var createClient = function createClient(config) {
	  return new Client(config);
	};
	/**
	 * Fetches the global default client.
	 */

	var getDefaultClient = function getDefaultClient() {
	  if (!defaultClientSingleton) {
	    defaultClientSingleton = createClient();
	  }

	  return defaultClientSingleton;
	};
	/**
	 * The global default client. Note, this client may not get torn down.
	 */

	var defaultClientSingleton;

	var FormspreeContext = React__default["default"].createContext({
	  client: undefined
	});
	FormspreeContext.displayName = 'Formspree';
	var FormspreeProvider = function FormspreeProvider(props) {
	  if (!props.project) {
	    throw new Error('project is required');
	  }

	  var _useState = React.useState(function () {
	    return createClient({
	      project: props.project
	    });
	  }),
	      _useState2 = slicedToArray(_useState, 1),
	      client = _useState2[0];

	  React.useEffect(function () {
	    client.startBrowserSession();
	    return function () {
	      client.teardown();
	    };
	  }, []);
	  return React__default["default"].createElement(FormspreeContext.Provider, {
	    value: {
	      client: client
	    }
	  }, props.children);
	};
	function useFormspree() {
	  var _useContext = React.useContext(FormspreeContext),
	      client = _useContext.client;

	  return client || getDefaultClient();
	}

	var runtime = {exports: {}};

	/**
	 * Copyright (c) 2014-present, Facebook, Inc.
	 *
	 * This source code is licensed under the MIT license found in the
	 * LICENSE file in the root directory of this source tree.
	 */

	(function (module) {
	var runtime = (function (exports) {

	  var Op = Object.prototype;
	  var hasOwn = Op.hasOwnProperty;
	  var undefined$1; // More compressible than void 0.
	  var $Symbol = typeof Symbol === "function" ? Symbol : {};
	  var iteratorSymbol = $Symbol.iterator || "@@iterator";
	  var asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator";
	  var toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag";

	  function wrap(innerFn, outerFn, self, tryLocsList) {
	    // If outerFn provided and outerFn.prototype is a Generator, then outerFn.prototype instanceof Generator.
	    var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator;
	    var generator = Object.create(protoGenerator.prototype);
	    var context = new Context(tryLocsList || []);

	    // The ._invoke method unifies the implementations of the .next,
	    // .throw, and .return methods.
	    generator._invoke = makeInvokeMethod(innerFn, self, context);

	    return generator;
	  }
	  exports.wrap = wrap;

	  // Try/catch helper to minimize deoptimizations. Returns a completion
	  // record like context.tryEntries[i].completion. This interface could
	  // have been (and was previously) designed to take a closure to be
	  // invoked without arguments, but in all the cases we care about we
	  // already have an existing method we want to call, so there's no need
	  // to create a new function object. We can even get away with assuming
	  // the method takes exactly one argument, since that happens to be true
	  // in every case, so we don't have to touch the arguments object. The
	  // only additional allocation required is the completion record, which
	  // has a stable shape and so hopefully should be cheap to allocate.
	  function tryCatch(fn, obj, arg) {
	    try {
	      return { type: "normal", arg: fn.call(obj, arg) };
	    } catch (err) {
	      return { type: "throw", arg: err };
	    }
	  }

	  var GenStateSuspendedStart = "suspendedStart";
	  var GenStateSuspendedYield = "suspendedYield";
	  var GenStateExecuting = "executing";
	  var GenStateCompleted = "completed";

	  // Returning this object from the innerFn has the same effect as
	  // breaking out of the dispatch switch statement.
	  var ContinueSentinel = {};

	  // Dummy constructor functions that we use as the .constructor and
	  // .constructor.prototype properties for functions that return Generator
	  // objects. For full spec compliance, you may wish to configure your
	  // minifier not to mangle the names of these two functions.
	  function Generator() {}
	  function GeneratorFunction() {}
	  function GeneratorFunctionPrototype() {}

	  // This is a polyfill for %IteratorPrototype% for environments that
	  // don't natively support it.
	  var IteratorPrototype = {};
	  IteratorPrototype[iteratorSymbol] = function () {
	    return this;
	  };

	  var getProto = Object.getPrototypeOf;
	  var NativeIteratorPrototype = getProto && getProto(getProto(values([])));
	  if (NativeIteratorPrototype &&
	      NativeIteratorPrototype !== Op &&
	      hasOwn.call(NativeIteratorPrototype, iteratorSymbol)) {
	    // This environment has a native %IteratorPrototype%; use it instead
	    // of the polyfill.
	    IteratorPrototype = NativeIteratorPrototype;
	  }

	  var Gp = GeneratorFunctionPrototype.prototype =
	    Generator.prototype = Object.create(IteratorPrototype);
	  GeneratorFunction.prototype = Gp.constructor = GeneratorFunctionPrototype;
	  GeneratorFunctionPrototype.constructor = GeneratorFunction;
	  GeneratorFunctionPrototype[toStringTagSymbol] =
	    GeneratorFunction.displayName = "GeneratorFunction";

	  // Helper for defining the .next, .throw, and .return methods of the
	  // Iterator interface in terms of a single ._invoke method.
	  function defineIteratorMethods(prototype) {
	    ["next", "throw", "return"].forEach(function(method) {
	      prototype[method] = function(arg) {
	        return this._invoke(method, arg);
	      };
	    });
	  }

	  exports.isGeneratorFunction = function(genFun) {
	    var ctor = typeof genFun === "function" && genFun.constructor;
	    return ctor
	      ? ctor === GeneratorFunction ||
	        // For the native GeneratorFunction constructor, the best we can
	        // do is to check its .name property.
	        (ctor.displayName || ctor.name) === "GeneratorFunction"
	      : false;
	  };

	  exports.mark = function(genFun) {
	    if (Object.setPrototypeOf) {
	      Object.setPrototypeOf(genFun, GeneratorFunctionPrototype);
	    } else {
	      genFun.__proto__ = GeneratorFunctionPrototype;
	      if (!(toStringTagSymbol in genFun)) {
	        genFun[toStringTagSymbol] = "GeneratorFunction";
	      }
	    }
	    genFun.prototype = Object.create(Gp);
	    return genFun;
	  };

	  // Within the body of any async function, `await x` is transformed to
	  // `yield regeneratorRuntime.awrap(x)`, so that the runtime can test
	  // `hasOwn.call(value, "__await")` to determine if the yielded value is
	  // meant to be awaited.
	  exports.awrap = function(arg) {
	    return { __await: arg };
	  };

	  function AsyncIterator(generator) {
	    function invoke(method, arg, resolve, reject) {
	      var record = tryCatch(generator[method], generator, arg);
	      if (record.type === "throw") {
	        reject(record.arg);
	      } else {
	        var result = record.arg;
	        var value = result.value;
	        if (value &&
	            typeof value === "object" &&
	            hasOwn.call(value, "__await")) {
	          return Promise.resolve(value.__await).then(function(value) {
	            invoke("next", value, resolve, reject);
	          }, function(err) {
	            invoke("throw", err, resolve, reject);
	          });
	        }

	        return Promise.resolve(value).then(function(unwrapped) {
	          // When a yielded Promise is resolved, its final value becomes
	          // the .value of the Promise<{value,done}> result for the
	          // current iteration.
	          result.value = unwrapped;
	          resolve(result);
	        }, function(error) {
	          // If a rejected Promise was yielded, throw the rejection back
	          // into the async generator function so it can be handled there.
	          return invoke("throw", error, resolve, reject);
	        });
	      }
	    }

	    var previousPromise;

	    function enqueue(method, arg) {
	      function callInvokeWithMethodAndArg() {
	        return new Promise(function(resolve, reject) {
	          invoke(method, arg, resolve, reject);
	        });
	      }

	      return previousPromise =
	        // If enqueue has been called before, then we want to wait until
	        // all previous Promises have been resolved before calling invoke,
	        // so that results are always delivered in the correct order. If
	        // enqueue has not been called before, then it is important to
	        // call invoke immediately, without waiting on a callback to fire,
	        // so that the async generator function has the opportunity to do
	        // any necessary setup in a predictable way. This predictability
	        // is why the Promise constructor synchronously invokes its
	        // executor callback, and why async functions synchronously
	        // execute code before the first await. Since we implement simple
	        // async functions in terms of async generators, it is especially
	        // important to get this right, even though it requires care.
	        previousPromise ? previousPromise.then(
	          callInvokeWithMethodAndArg,
	          // Avoid propagating failures to Promises returned by later
	          // invocations of the iterator.
	          callInvokeWithMethodAndArg
	        ) : callInvokeWithMethodAndArg();
	    }

	    // Define the unified helper method that is used to implement .next,
	    // .throw, and .return (see defineIteratorMethods).
	    this._invoke = enqueue;
	  }

	  defineIteratorMethods(AsyncIterator.prototype);
	  AsyncIterator.prototype[asyncIteratorSymbol] = function () {
	    return this;
	  };
	  exports.AsyncIterator = AsyncIterator;

	  // Note that simple async functions are implemented on top of
	  // AsyncIterator objects; they just return a Promise for the value of
	  // the final result produced by the iterator.
	  exports.async = function(innerFn, outerFn, self, tryLocsList) {
	    var iter = new AsyncIterator(
	      wrap(innerFn, outerFn, self, tryLocsList)
	    );

	    return exports.isGeneratorFunction(outerFn)
	      ? iter // If outerFn is a generator, return the full iterator.
	      : iter.next().then(function(result) {
	          return result.done ? result.value : iter.next();
	        });
	  };

	  function makeInvokeMethod(innerFn, self, context) {
	    var state = GenStateSuspendedStart;

	    return function invoke(method, arg) {
	      if (state === GenStateExecuting) {
	        throw new Error("Generator is already running");
	      }

	      if (state === GenStateCompleted) {
	        if (method === "throw") {
	          throw arg;
	        }

	        // Be forgiving, per 25.3.3.3.3 of the spec:
	        // https://people.mozilla.org/~jorendorff/es6-draft.html#sec-generatorresume
	        return doneResult();
	      }

	      context.method = method;
	      context.arg = arg;

	      while (true) {
	        var delegate = context.delegate;
	        if (delegate) {
	          var delegateResult = maybeInvokeDelegate(delegate, context);
	          if (delegateResult) {
	            if (delegateResult === ContinueSentinel) continue;
	            return delegateResult;
	          }
	        }

	        if (context.method === "next") {
	          // Setting context._sent for legacy support of Babel's
	          // function.sent implementation.
	          context.sent = context._sent = context.arg;

	        } else if (context.method === "throw") {
	          if (state === GenStateSuspendedStart) {
	            state = GenStateCompleted;
	            throw context.arg;
	          }

	          context.dispatchException(context.arg);

	        } else if (context.method === "return") {
	          context.abrupt("return", context.arg);
	        }

	        state = GenStateExecuting;

	        var record = tryCatch(innerFn, self, context);
	        if (record.type === "normal") {
	          // If an exception is thrown from innerFn, we leave state ===
	          // GenStateExecuting and loop back for another invocation.
	          state = context.done
	            ? GenStateCompleted
	            : GenStateSuspendedYield;

	          if (record.arg === ContinueSentinel) {
	            continue;
	          }

	          return {
	            value: record.arg,
	            done: context.done
	          };

	        } else if (record.type === "throw") {
	          state = GenStateCompleted;
	          // Dispatch the exception by looping back around to the
	          // context.dispatchException(context.arg) call above.
	          context.method = "throw";
	          context.arg = record.arg;
	        }
	      }
	    };
	  }

	  // Call delegate.iterator[context.method](context.arg) and handle the
	  // result, either by returning a { value, done } result from the
	  // delegate iterator, or by modifying context.method and context.arg,
	  // setting context.delegate to null, and returning the ContinueSentinel.
	  function maybeInvokeDelegate(delegate, context) {
	    var method = delegate.iterator[context.method];
	    if (method === undefined$1) {
	      // A .throw or .return when the delegate iterator has no .throw
	      // method always terminates the yield* loop.
	      context.delegate = null;

	      if (context.method === "throw") {
	        // Note: ["return"] must be used for ES3 parsing compatibility.
	        if (delegate.iterator["return"]) {
	          // If the delegate iterator has a return method, give it a
	          // chance to clean up.
	          context.method = "return";
	          context.arg = undefined$1;
	          maybeInvokeDelegate(delegate, context);

	          if (context.method === "throw") {
	            // If maybeInvokeDelegate(context) changed context.method from
	            // "return" to "throw", let that override the TypeError below.
	            return ContinueSentinel;
	          }
	        }

	        context.method = "throw";
	        context.arg = new TypeError(
	          "The iterator does not provide a 'throw' method");
	      }

	      return ContinueSentinel;
	    }

	    var record = tryCatch(method, delegate.iterator, context.arg);

	    if (record.type === "throw") {
	      context.method = "throw";
	      context.arg = record.arg;
	      context.delegate = null;
	      return ContinueSentinel;
	    }

	    var info = record.arg;

	    if (! info) {
	      context.method = "throw";
	      context.arg = new TypeError("iterator result is not an object");
	      context.delegate = null;
	      return ContinueSentinel;
	    }

	    if (info.done) {
	      // Assign the result of the finished delegate to the temporary
	      // variable specified by delegate.resultName (see delegateYield).
	      context[delegate.resultName] = info.value;

	      // Resume execution at the desired location (see delegateYield).
	      context.next = delegate.nextLoc;

	      // If context.method was "throw" but the delegate handled the
	      // exception, let the outer generator proceed normally. If
	      // context.method was "next", forget context.arg since it has been
	      // "consumed" by the delegate iterator. If context.method was
	      // "return", allow the original .return call to continue in the
	      // outer generator.
	      if (context.method !== "return") {
	        context.method = "next";
	        context.arg = undefined$1;
	      }

	    } else {
	      // Re-yield the result returned by the delegate method.
	      return info;
	    }

	    // The delegate iterator is finished, so forget it and continue with
	    // the outer generator.
	    context.delegate = null;
	    return ContinueSentinel;
	  }

	  // Define Generator.prototype.{next,throw,return} in terms of the
	  // unified ._invoke helper method.
	  defineIteratorMethods(Gp);

	  Gp[toStringTagSymbol] = "Generator";

	  // A Generator should always return itself as the iterator object when the
	  // @@iterator function is called on it. Some browsers' implementations of the
	  // iterator prototype chain incorrectly implement this, causing the Generator
	  // object to not be returned from this call. This ensures that doesn't happen.
	  // See https://github.com/facebook/regenerator/issues/274 for more details.
	  Gp[iteratorSymbol] = function() {
	    return this;
	  };

	  Gp.toString = function() {
	    return "[object Generator]";
	  };

	  function pushTryEntry(locs) {
	    var entry = { tryLoc: locs[0] };

	    if (1 in locs) {
	      entry.catchLoc = locs[1];
	    }

	    if (2 in locs) {
	      entry.finallyLoc = locs[2];
	      entry.afterLoc = locs[3];
	    }

	    this.tryEntries.push(entry);
	  }

	  function resetTryEntry(entry) {
	    var record = entry.completion || {};
	    record.type = "normal";
	    delete record.arg;
	    entry.completion = record;
	  }

	  function Context(tryLocsList) {
	    // The root entry object (effectively a try statement without a catch
	    // or a finally block) gives us a place to store values thrown from
	    // locations where there is no enclosing try statement.
	    this.tryEntries = [{ tryLoc: "root" }];
	    tryLocsList.forEach(pushTryEntry, this);
	    this.reset(true);
	  }

	  exports.keys = function(object) {
	    var keys = [];
	    for (var key in object) {
	      keys.push(key);
	    }
	    keys.reverse();

	    // Rather than returning an object with a next method, we keep
	    // things simple and return the next function itself.
	    return function next() {
	      while (keys.length) {
	        var key = keys.pop();
	        if (key in object) {
	          next.value = key;
	          next.done = false;
	          return next;
	        }
	      }

	      // To avoid creating an additional object, we just hang the .value
	      // and .done properties off the next function object itself. This
	      // also ensures that the minifier will not anonymize the function.
	      next.done = true;
	      return next;
	    };
	  };

	  function values(iterable) {
	    if (iterable) {
	      var iteratorMethod = iterable[iteratorSymbol];
	      if (iteratorMethod) {
	        return iteratorMethod.call(iterable);
	      }

	      if (typeof iterable.next === "function") {
	        return iterable;
	      }

	      if (!isNaN(iterable.length)) {
	        var i = -1, next = function next() {
	          while (++i < iterable.length) {
	            if (hasOwn.call(iterable, i)) {
	              next.value = iterable[i];
	              next.done = false;
	              return next;
	            }
	          }

	          next.value = undefined$1;
	          next.done = true;

	          return next;
	        };

	        return next.next = next;
	      }
	    }

	    // Return an iterator with no values.
	    return { next: doneResult };
	  }
	  exports.values = values;

	  function doneResult() {
	    return { value: undefined$1, done: true };
	  }

	  Context.prototype = {
	    constructor: Context,

	    reset: function(skipTempReset) {
	      this.prev = 0;
	      this.next = 0;
	      // Resetting context._sent for legacy support of Babel's
	      // function.sent implementation.
	      this.sent = this._sent = undefined$1;
	      this.done = false;
	      this.delegate = null;

	      this.method = "next";
	      this.arg = undefined$1;

	      this.tryEntries.forEach(resetTryEntry);

	      if (!skipTempReset) {
	        for (var name in this) {
	          // Not sure about the optimal order of these conditions:
	          if (name.charAt(0) === "t" &&
	              hasOwn.call(this, name) &&
	              !isNaN(+name.slice(1))) {
	            this[name] = undefined$1;
	          }
	        }
	      }
	    },

	    stop: function() {
	      this.done = true;

	      var rootEntry = this.tryEntries[0];
	      var rootRecord = rootEntry.completion;
	      if (rootRecord.type === "throw") {
	        throw rootRecord.arg;
	      }

	      return this.rval;
	    },

	    dispatchException: function(exception) {
	      if (this.done) {
	        throw exception;
	      }

	      var context = this;
	      function handle(loc, caught) {
	        record.type = "throw";
	        record.arg = exception;
	        context.next = loc;

	        if (caught) {
	          // If the dispatched exception was caught by a catch block,
	          // then let that catch block handle the exception normally.
	          context.method = "next";
	          context.arg = undefined$1;
	        }

	        return !! caught;
	      }

	      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
	        var entry = this.tryEntries[i];
	        var record = entry.completion;

	        if (entry.tryLoc === "root") {
	          // Exception thrown outside of any try block that could handle
	          // it, so set the completion value of the entire function to
	          // throw the exception.
	          return handle("end");
	        }

	        if (entry.tryLoc <= this.prev) {
	          var hasCatch = hasOwn.call(entry, "catchLoc");
	          var hasFinally = hasOwn.call(entry, "finallyLoc");

	          if (hasCatch && hasFinally) {
	            if (this.prev < entry.catchLoc) {
	              return handle(entry.catchLoc, true);
	            } else if (this.prev < entry.finallyLoc) {
	              return handle(entry.finallyLoc);
	            }

	          } else if (hasCatch) {
	            if (this.prev < entry.catchLoc) {
	              return handle(entry.catchLoc, true);
	            }

	          } else if (hasFinally) {
	            if (this.prev < entry.finallyLoc) {
	              return handle(entry.finallyLoc);
	            }

	          } else {
	            throw new Error("try statement without catch or finally");
	          }
	        }
	      }
	    },

	    abrupt: function(type, arg) {
	      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
	        var entry = this.tryEntries[i];
	        if (entry.tryLoc <= this.prev &&
	            hasOwn.call(entry, "finallyLoc") &&
	            this.prev < entry.finallyLoc) {
	          var finallyEntry = entry;
	          break;
	        }
	      }

	      if (finallyEntry &&
	          (type === "break" ||
	           type === "continue") &&
	          finallyEntry.tryLoc <= arg &&
	          arg <= finallyEntry.finallyLoc) {
	        // Ignore the finally entry if control is not jumping to a
	        // location outside the try/catch block.
	        finallyEntry = null;
	      }

	      var record = finallyEntry ? finallyEntry.completion : {};
	      record.type = type;
	      record.arg = arg;

	      if (finallyEntry) {
	        this.method = "next";
	        this.next = finallyEntry.finallyLoc;
	        return ContinueSentinel;
	      }

	      return this.complete(record);
	    },

	    complete: function(record, afterLoc) {
	      if (record.type === "throw") {
	        throw record.arg;
	      }

	      if (record.type === "break" ||
	          record.type === "continue") {
	        this.next = record.arg;
	      } else if (record.type === "return") {
	        this.rval = this.arg = record.arg;
	        this.method = "return";
	        this.next = "end";
	      } else if (record.type === "normal" && afterLoc) {
	        this.next = afterLoc;
	      }

	      return ContinueSentinel;
	    },

	    finish: function(finallyLoc) {
	      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
	        var entry = this.tryEntries[i];
	        if (entry.finallyLoc === finallyLoc) {
	          this.complete(entry.completion, entry.afterLoc);
	          resetTryEntry(entry);
	          return ContinueSentinel;
	        }
	      }
	    },

	    "catch": function(tryLoc) {
	      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
	        var entry = this.tryEntries[i];
	        if (entry.tryLoc === tryLoc) {
	          var record = entry.completion;
	          if (record.type === "throw") {
	            var thrown = record.arg;
	            resetTryEntry(entry);
	          }
	          return thrown;
	        }
	      }

	      // The context.catch method must only be called with a location
	      // argument that corresponds to a known catch block.
	      throw new Error("illegal catch attempt");
	    },

	    delegateYield: function(iterable, resultName, nextLoc) {
	      this.delegate = {
	        iterator: values(iterable),
	        resultName: resultName,
	        nextLoc: nextLoc
	      };

	      if (this.method === "next") {
	        // Deliberately forget the last sent value so that we don't
	        // accidentally pass it on to the delegate.
	        this.arg = undefined$1;
	      }

	      return ContinueSentinel;
	    }
	  };

	  // Regardless of whether this script is executing as a CommonJS module
	  // or not, return the runtime object so that we can declare the variable
	  // regeneratorRuntime in the outer scope, which allows this module to be
	  // injected easily by `bin/regenerator --include-runtime script.js`.
	  return exports;

	}(
	  // If this script is executing as a CommonJS module, use module.exports
	  // as the regeneratorRuntime namespace. Otherwise create a new empty
	  // object. Either way, the resulting object will be used to initialize
	  // the regeneratorRuntime variable at the top of this file.
	  module.exports 
	));

	try {
	  regeneratorRuntime = runtime;
	} catch (accidentalStrictMode) {
	  // This module should not be running in strict mode, so the above
	  // assignment should always work unless something is misconfigured. Just
	  // in case runtime.js accidentally runs in strict mode, we can escape
	  // strict mode using a global Function call. This could conceivably fail
	  // if a Content Security Policy forbids using Function, but in that case
	  // the proper solution is to fix the accidental strict mode problem. If
	  // you've misconfigured your bundler to force strict mode and applied a
	  // CSP to forbid Function, and you're not willing to fix either of those
	  // problems, please detail your unique predicament in a GitHub issue.
	  Function("r", "regeneratorRuntime = r")(runtime);
	}
	}(runtime));

	var regenerator = runtime.exports;

	function _typeof2(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof2 = function _typeof2(obj) { return typeof obj; }; } else { _typeof2 = function _typeof2(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof2(obj); }

	function _typeof(obj) {
	  if (typeof Symbol === "function" && _typeof2(Symbol.iterator) === "symbol") {
	    _typeof_1 = _typeof = function _typeof(obj) {
	      return _typeof2(obj);
	    };
	  } else {
	    _typeof_1 = _typeof = function _typeof(obj) {
	      return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : _typeof2(obj);
	    };
	  }

	  return _typeof(obj);
	}

	var _typeof_1 = _typeof;

	var _typeof$1 = _typeof_1;

	function _defineProperty(obj, key, value) {
	  if (key in obj) {
	    Object.defineProperty(obj, key, {
	      value: value,
	      enumerable: true,
	      configurable: true,
	      writable: true
	    });
	  } else {
	    obj[key] = value;
	  }

	  return obj;
	}

	var defineProperty = _defineProperty;

	function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
	  try {
	    var info = gen[key](arg);
	    var value = info.value;
	  } catch (error) {
	    reject(error);
	    return;
	  }

	  if (info.done) {
	    resolve(value);
	  } else {
	    Promise.resolve(value).then(_next, _throw);
	  }
	}

	function _asyncToGenerator(fn) {
	  return function () {
	    var self = this,
	        args = arguments;
	    return new Promise(function (resolve, reject) {
	      var gen = fn.apply(self, args);

	      function _next(value) {
	        asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
	      }

	      function _throw(err) {
	        asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
	      }

	      _next(undefined);
	    });
	  };
	}

	var asyncToGenerator = _asyncToGenerator;

	var version = "2.2.5";

	function isEvent(data) {
	  return data.preventDefault !== undefined;
	}

	function useForm(formKey) {
	  var args = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

	  var _useState = React.useState(false),
	      _useState2 = slicedToArray(_useState, 2),
	      submitting = _useState2[0],
	      setSubmitting = _useState2[1];

	  var _useState3 = React.useState(false),
	      _useState4 = slicedToArray(_useState3, 2),
	      succeeded = _useState4[0],
	      setSucceeded = _useState4[1];

	  var _useState5 = React.useState([]),
	      _useState6 = slicedToArray(_useState5, 2),
	      errors = _useState6[0],
	      setErrors = _useState6[1];

	  var globalClient = useFormspree();
	  var client = args.client || globalClient;

	  if (!client) {
	    throw new Error('You must provide a Formspree client');
	  }

	  if (!formKey) {
	    throw new Error('You must provide a form key or hashid ' + '(e.g. useForm("myForm") or useForm("123xyz")');
	  }

	  var debug = !!args.debug;
	  var extraData = args.data;

	  var reset = function reset() {
	    setSubmitting(false);
	    setSucceeded(false);
	    setErrors([]);
	  };

	  var handleSubmit =
	  /*#__PURE__*/
	  function () {
	    var _ref = asyncToGenerator(
	    /*#__PURE__*/
	    regenerator.mark(function _callee(submissionData) {
	      var getFormData, formData, appendExtraData, prop, extraDataValue;
	      return regenerator.wrap(function _callee$(_context) {
	        while (1) {
	          switch (_context.prev = _context.next) {
	            case 0:
	              getFormData = function getFormData(event) {
	                event.preventDefault();
	                var form = event.target;

	                if (form.tagName != 'FORM') {
	                  throw new Error('submit was triggered for a non-form element');
	                }

	                return new FormData(form);
	              };

	              formData = isEvent(submissionData) ? getFormData(submissionData) : submissionData;

	              appendExtraData = function appendExtraData(prop, value) {
	                if (formData instanceof FormData) {
	                  formData.append(prop, value);
	                } else {
	                  formData = Object.assign(formData, defineProperty({}, prop, value));
	                }
	              }; // Append extra data from config


	              if (!(_typeof$1(extraData) === 'object')) {
	                _context.next = 19;
	                break;
	              }

	              _context.t0 = regenerator.keys(extraData);

	            case 5:
	              if ((_context.t1 = _context.t0()).done) {
	                _context.next = 19;
	                break;
	              }

	              prop = _context.t1.value;

	              if (!(typeof extraData[prop] === 'function')) {
	                _context.next = 16;
	                break;
	              }

	              extraDataValue = extraData[prop].call(null);

	              if (!(extraDataValue instanceof Promise)) {
	                _context.next = 13;
	                break;
	              }

	              _context.next = 12;
	              return extraDataValue;

	            case 12:
	              extraDataValue = _context.sent;

	            case 13:
	              if (extraDataValue !== undefined) {
	                appendExtraData(prop, extraDataValue);
	              }

	              _context.next = 17;
	              break;

	            case 16:
	              appendExtraData(prop, extraData[prop]);

	            case 17:
	              _context.next = 5;
	              break;

	            case 19:
	              setSubmitting(true);
	              return _context.abrupt("return", client.submitForm(formKey, formData, {
	                endpoint: args.endpoint,
	                clientName: "@formspree/react@".concat(version)
	              }).then(function (result) {
	                var status = result.response.status;
	                var body;

	                if (status === 200) {
	                  if (debug) console.log('Form submitted', result);
	                  setSucceeded(true);
	                  setErrors([]);
	                } else if (status >= 400 && status < 500) {
	                  body = result.body;
	                  if (body.errors) setErrors(body.errors);
	                  if (debug) console.log('Validation error', result);
	                  setSucceeded(false);
	                } else {
	                  if (debug) console.log('Unexpected error', result);
	                  setSucceeded(false);
	                }

	                return result;
	              })["catch"](function (error) {
	                if (debug) console.log('Unexpected error', error);
	                setSucceeded(false);
	                throw error;
	              })["finally"](function () {
	                setSubmitting(false);
	              }));

	            case 21:
	            case "end":
	              return _context.stop();
	          }
	        }
	      }, _callee);
	    }));

	    return function handleSubmit(_x) {
	      return _ref.apply(this, arguments);
	    };
	  }();

	  return [{
	    submitting: submitting,
	    succeeded: succeeded,
	    errors: errors
	  }, handleSubmit, reset];
	}

	function _objectWithoutPropertiesLoose(source, excluded) {
	  if (source == null) return {};
	  var target = {};
	  var sourceKeys = Object.keys(source);
	  var key, i;

	  for (i = 0; i < sourceKeys.length; i++) {
	    key = sourceKeys[i];
	    if (excluded.indexOf(key) >= 0) continue;
	    target[key] = source[key];
	  }

	  return target;
	}

	var objectWithoutPropertiesLoose$1 = _objectWithoutPropertiesLoose;

	var objectWithoutPropertiesLoose = objectWithoutPropertiesLoose$1;

	function _objectWithoutProperties(source, excluded) {
	  if (source == null) return {};
	  var target = objectWithoutPropertiesLoose(source, excluded);
	  var key, i;

	  if (Object.getOwnPropertySymbols) {
	    var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

	    for (i = 0; i < sourceSymbolKeys.length; i++) {
	      key = sourceSymbolKeys[i];
	      if (excluded.indexOf(key) >= 0) continue;
	      if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
	      target[key] = source[key];
	    }
	  }

	  return target;
	}

	var objectWithoutProperties = _objectWithoutProperties;

	var ValidationError = function ValidationError(props) {
	  var prefix = props.prefix,
	      field = props.field,
	      errors = props.errors,
	      attrs = objectWithoutProperties(props, ["prefix", "field", "errors"]);

	  var error = (errors || []).find(function (error) {
	    return error.field == field;
	  });

	  if (!error) {
	    return null;
	  }

	  return React__default["default"].createElement("div", attrs, prefix, " ", error.message);
	};

	exports.FormspreeProvider = FormspreeProvider;
	exports.ValidationError = ValidationError;
	exports.useForm = useForm;
	exports.useFormspree = useFormspree;

	Object.defineProperty(exports, '__esModule', { value: true });

	return exports;

})({}, React);
