/**
 * Base-64 encodes a (JSON-castable) object.
 *
 * @param obj - The object to encode.
 */
export declare const encode64: (obj: object) => string;
/**
 * Appends a key-value pair to a target.
 *
 * @param target - An object or FormData instance to mutate.
 * @param key - The key to append.
 * @param value - The value to append.
 */
export declare const append: (target: FormData | {
    [key: string]: any;
}, key: string, value: string) => void;
/**
 * Converts a snake case string to camel case.
 *
 * @param str - A string to convert to camel case.
 */
export declare const toCamel: (str: string) => string;
/**
 * Converts the top-level keys of an object to camel case.
 * This function returns a new object (instead of mutating in place).
 *
 * @param obj - An object with string keys.
 */
export declare const camelizeTopKeys: (obj: {
    [key: string]: any;
}) => {
    [key: string]: any;
};
/**
 * Generates a client header.
 *
 * @param givenLabel
 */
export declare const clientHeader: (givenLabel: string | undefined) => string;
/**
 * The current timestamp.
 */
export declare const now: () => number;
